; JFW 3.3 Script file for Microsoft Access 97
; Copyright 1998-99 by Henter-Joyce, Inc.
; Written by Joseph K Stephen (formerly Dunn).
; build ac332540 last modified 18 June 1999
; This file contains support for Access 2.0 and 95
; see msaccess.jss for support of Access 97/2000

include "accessal.jsh" ; constants and globals applicable to all versions of Access.
include "access95.jsh" ; Constants and globals applicable to Access 95 and earlier.
include "accessal.jsm" ; messages applicable to all versions of Access.
include "access95.jsm"
include "hjconst.jsh"
include "hjglobal.jsh"

Function AutoStartEvent ()
if (HasRunBefore == false) then
	let HasRunBefore = true
	if (GetVerbosity() == beginner) then
		Say(msg1, ot_help) ;"Use Insert plus the letter H for help in various dialog boxes"
	EndIf
EndIf
EndFunction

Script SayStatusLine ()
var
   HANDLE hWnd

let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)
while (hWnd)
;wc112="ostatbar"
   if (GetWindowClass(hWnd) == wc112) then
      SayWindow(hWnd,0)
      return
   EndIf
   let hWnd = GetNextWindow(hWnd)
endwhile
EndScript

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
HANDLE RealWindow,
string RealWindowName,
HANDLE AppWindow

let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)

;wc113="_sdm_"
if (StringContains (GetWindowClass (RealWindow), wc113)) then
; we are in an SDM dialog
let GlobalRealWindow = RealWindow
let GlobalRealWindowName = RealWindowName
let GlobalFocusWindow = FocusWindow
SaySDMFocusedWindow()
Else ; not sdm
;start of regular non-sdm logic
if (GlobalPrevApp != AppWindow
&& AppWindow != FocusWindow) then
; we've switched to a different app main window,
; and it does not have the focus, so announce it
SayWindowTypeAndText(AppWindow)
EndIf

If ((GlobalPrevRealName != RealWindowName) ; name has changed
|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
If ((RealWindow != AppWindow)
&& (RealWindow != FocusWindow)) then
SayWindowTypeAndText(RealWindow)
EndIf
EndIf
; now say the window with focus
let GlobalFocusWindow = FocusWindow ; to access it from another routine
SayFocusedWindow()
EndIf ;end else sdm
#now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

; called by focus changed, to handle sdm dialogs
Function SaySDMFocusedWindow ()
let GlobalCurrentControl = SdmGetFocus (GlobalFocusWindow)
;wn114="Spelling:"
if ((GlobalRealWindowName == wn114) 
&& (GlobalCurrentControl == SpellWordNotFoundId)) then 
;Say (GlobalRealWindowName, ot_string) ; say just the title here,
; highlighted text event says the mispelled word
return
EndIf ; spell dialog box on "word not found"
; If we've just entered a new real window say it
If (GlobalPrevReal != GlobalRealWindow)
|| GlobalRealWindowName != GlobalPrevRealName then
SayWindowTypeAndText (GlobalRealWindow) ; dialog box name
;SdmSayWindowTypeAndText (GlobalRealWindow, SdmGetFocus (GlobalRealWindow ))
SdmSayStaticText (GlobalRealWindow) ;dialog box text
EndIf ; new real window handle or name
; now say the current control
If (GlobalCurrentControl > 0) then
SdmSayWindowTypeAndText (GlobalFocusWindow, GlobalCurrentControl)
EndIf ; control id > 0
EndFunction

; called by focus changed, to say the control with focus
Function SayFocusedWindow ()
var
string realName
let realName=getWindowName(GetRealWindow(globalFocusWindow))
if stringContains(realName,accmsg4) then
	performScript sayTblDesignViewPrompt()
	return
endIf

if (GetWindowTypeCode(GlobalFocusWindow) != wt_Unknown) then
		SayPrompt ()
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Function SayPrompt ()
var
	Handle Parent,
	string class,
	int Left,
	int Right
let Parent= GetParent(GlobalFocusWindow)
let class = GetWindowClass (parent)
saveCursor()
InvisibleCursor()
;wc117="ogrid"
if (class == wc117) then
	let Left = GetWindowLeft(GlobalFocusWindow)
	let Right = GetWindowRight(GlobalFocusWindow)
	MoveToWindow(Parent)
	SayTextBetween(Left,Right)
EndIf
;wc118="oform"
if (GetWindowClass(Parent)== wc118) then
; first, figure out if the prompts are in a single line window above the data window
	MoveToWindow (parent)
	if ToggleRestriction () then
		ToggleRestriction ()
	EndIf
	PriorLine ()
	JawsHome ()
	if (StringContains (GetWindowClass (GetCurrentWindow ()), class)
		&& StringContains (class, GetWindowClass (GetCurrentWindow ()))) then ; this are the prompts
		let Left = GetWindowLeft(GlobalFocusWindow)
		let Right = GetWindowRight(GlobalFocusWindow)
		SayTextBetween(Left,Right)
		return
	EndIf
; prompts seem to be to the left
RouteInvisibleToPC()
PriorChunk()
SayChunk()
EndIf
RestoreCursor()
EndFunction

Script  ScriptFileName()
ScriptAndAppNames (msg3) ; access 95 or earlier
EndScript

Script  SpellCheck()
;wn114="Spelling:"
If (GetWindowName (GetRealWindow(GetCurrentWindow())) == wn114) Then
RouteInvisibleToPc()
InvisibleCursor()
JawsPageUp()
NextLine()
JawsEnd()
If (GetVerbosity () > 0) then
SayWord ()
Else
SayLine ()
EndIf
SpellWord() ;spell it either way
NextLine()
JawsEnd ()
If (GetVerbosity () > beginner) then
SayWord ()
Else
SayLine()
EndIf
SpellWord() ;spell it either way
PcCursor()
Else
Say (msg128, ot_status) ;"Not in spell checker"
EndIf
EndScript


Void Function SayHighlightedText (handle CurrentWindow, string buffer)
if(GetScreenEcho() > 0) Then
if ((GlobalCurrentControl == 29)
;wn114="Spelling:"
&& (GlobalPrevRealName == wn114)) then
else
SayString(buffer)
EndIf
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
string TheClass
let TheClass = GetWindowClass(hwnd)
if ((GetScreenEcho() > 1) ||
;wn129="#32771"
(TheClass == wn129 )) then
Say(buffer, ot_buffer)
Return
EndIf
if (GlobalCurrentControl == SpellWordNotFoundId) then
;wn114="Spelling:"
if (GlobalPrevRealName == wn114) then
;wn130="Not in Dictionary"
if ((StringContains (buffer, wn130))
;wn131="Capitalization:"
|| (StringContains (buffer, wn131))
;wn132="Repeated Word:"
|| (StringContains (buffer, wn132))) then 
PerformScript SpellCheck()
EndIf
EndIf
EndIf
EndFunction

Script  SayField()
SayField ()
EndScript

Script  SayChunk()
SayChunk()
EndScript

;**************************************************************************************************
;**************************************** Access 97 Script ************************************
;**************************************************************************************************

Function IsMultiPageDialog ()
var
	handle WinHandle
let WinHandle = GetCurrentWindow ()
let WinHandle = GetRealWindow (WinHandle)
let WinHandle = GetFirstChild (WinHandle)
while (WinHandle)
	if (GetWindowTypeCode (WinHandle) == wt_TabControl) then
		return true
	EndIf
	let WinHandle = GetNextWindow (WinHandle)
EndWhile
return false
EndFunction

Function Unknown (string TheName, int IsScript)
; ignore  
say(msg4,ot_help)
EndFunction


Script enterKey ()
; this script does something more in Access 97/2000 
; but is required here to avoid an unknown function call occuring and so that the keystroke is passed to the application.
{enter}
endScript

Script TabKey ()
; this script does something more in Access 97/2000 
; but is required here to avoid an unknown function call occuring and so that the keystroke is passed to the application.
{tab}
EndScript

Script ShiftTabKey ()
; this script does something more in Access 97/2000 
; but is required here to avoid an unknown function call occuring and so that the keystroke is passed to the application.
{shift+tab}
EndScript

Int Function InTblProperties ()
var
int vertDistance
let VertDistance=GetWindowTop(GetParent(GetFocus()))-getWindowTop(GetRealWindow(getFocus()))
; only reliable way of determining if in properties panel of table design view
return VertDistance > 100
EndFunction

Script sayTblDesignViewPrompt ()
if inTblProperties() then
	SaveCursor()
	RouteInvisibleToPc()
	invisibleCursor()
	PriorChunk()
	SayChunk()
	restorecursor()
else
	sayPrompt()
endIf
EndScript
